oblib = require "objectdefs"

waveStartTime = Time.time
ourTime = Time.time
timeMult = 1

NORMAL = 0
THIN = 1
LARGE = 2

ORANGE = 0
BLUE = 1

PY = -42

gbs = {}
bots = {}
pbs = {}
sboxes = {}
boxes = {}
bolts = {}
pbombs = {}
pmetts = {}
hearts = {}

flow = {}
flowTime = Time.time
flowHUD = nil
flowHUDTime = Time.time

spawntimer = 0

circles = {}

debugs = {}

oneFrameBullets = {}

state = 0 -- State of player, 0 = Red, | 1 = Down, | 2 = Left, | 3 = Up, | 4 = Right
maxjump = 40 -- How high the player can jump.
jump = 0 -- Current jumping velocity. Can be set to any number within reason.
hurt = 1 -- If set to any number other than 0, then the player is invulnurable for 1 frame.
newpX = Player.x
newpY = Player.y

onPlatform = 0
platforms = {}

platSpawn = 50

Encounter.SetVar("wavetimer", 7.5)
Arena.Resize(245,200)


table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = 510, endX = 150, endY = 120, time = ourTime+0.5, rotation = 270, size = NORMAL, laserDelay = 0.75, laserLength = 0.80, s1 = false, s2 = false}))

table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = 510, endX = 540, endY = 290, time = ourTime+1.2, rotation = 90, size = LARGE, laserDelay = 0.75, laserLength = 1.4, s1 = false, s2 = false}))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = 510, endX = 540, endY = 100, time = ourTime+1.2, rotation = 90, size = LARGE, laserDelay = 0.75, laserLength = 1.4, s1 = false, s2 = false}))

table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = 510, endX = 320, endY = 420, time = ourTime+2.2, rotation = 0, size = LARGE, laserDelay = 0.75, laserLength = 0.80, s1 = false, s2 = false}))

table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = 510, endX = 180, endY = 280, time = ourTime+3.0, rotation = 270, size = NORMAL, laserDelay = 0.75, laserLength = 0.55, s1 = false, s2 = false }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = 510, endX = 210, endY = 320, time = ourTime+3.0, rotation = 0, size = NORMAL, laserDelay = 0.76, laserLength = 0.55, s1 = true, s2 = true }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = 670, startY = -30, endX = 540, endY = 100, time = ourTime+3.0, rotation = 90, size = NORMAL, laserDelay = 0.77, laserLength = 0.55, s1 = true, s2 = true }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = 670, startY = -30, endX = 420, endY = 30, time = ourTime+3.0, rotation = 180, size = NORMAL, laserDelay = 0.78, laserLength = 0.55, s1 = true, s2 = true }))

table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = 670, startY = 510, endX = -42, endY = 310, time = ourTime+4, rotation = 0, size = NORMAL, laserDelay = 0.75, laserLength = 0.55, s1 = false, s2 = false }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = 670, startY = 510, endX = 480, endY = -42, time = ourTime+4, rotation = 90, size = NORMAL, laserDelay = 0.76, laserLength = 0.55, s1 = true, s2 = true }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = -30, endX = -42, endY = 10, time = ourTime+4, rotation = 180, size = NORMAL, laserDelay = 0.77, laserLength = 0.55, s1 = true, s2 = true }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = -30, endX = 170, endY = -42, time = ourTime+4, rotation = 270, size = NORMAL, laserDelay = 0.78, laserLength = 0.55, s1 = true, s2 = true }))

table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = 510, endX = 180, endY = 280, time = ourTime+5.1, rotation = 270, size = NORMAL, laserDelay = 0.75, laserLength = 0.55, s1 = false, s2 = false }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = -30, startY = 510, endX = 210, endY = 320, time = ourTime+5.1, rotation = 0, size = NORMAL, laserDelay = 0.76, laserLength = 0.55, s1 = true, s2 = true }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = 670, startY = -30, endX = 540, endY = 100, time = ourTime+5.1, rotation = 90, size = NORMAL, laserDelay = 0.77, laserLength = 0.55, s1 = true, s2 = true }))
table.insert(gbs, oblib.GasterBlaster.new({ lifetime = 3, startX = 670, startY = -30, endX = 420, endY = 30, time = ourTime+5.1, rotation = 180, size = NORMAL, laserDelay = 0.78, laserLength = 0.55, s1 = true, s2 = true }))

function RenewMask()
	if state == 0 then
		Player.sprite.color = {1.0, 0.0, 0.0}
	elseif state == 1 then
		Player.sprite.color = {0.0, 0.0, 1.0}
	end
end

RenewMask()

topedge = Arena.height/2 - 8
rightedge = Arena.width/2 - 8
bottomedge = -Arena.height/2 + 8
leftedge = -Arena.width/2 + 8

function Update()
	spawntimer = spawntimer + 1

	if spawntimer == 10 then
		state = 1
		Audio.PlaySound("ding")
		RenewMask()
	end

	if spawntimer == 30 then
		jump = -100
		Audio.PlaySound("slam")
	end

	if spawntimer == 85 then
		state = 0
		Audio.PlaySound("ding")
		RenewMask()
	end
	for i=#gbs,1,-1 do
		if (gbs[i].rev == true) then
					--gbs[i].s1 = false
					--gbs[i].s2 = false
		end
	end

	ourTime = ourTime + (Time.dt * timeMult)

	for i=#oneFrameBullets,1,-1 do
		oneFrameBullets[i].Remove()
		table.remove(oneFrameBullets,i)
	end

	for i=#gbs,1,-1 do
		--Hacky solution to gaster blasters being, like, the only object that is on screen pretty much the first frame they appear
		if (ourTime > gbs[i].time) then gbs[i].Update()
		else gbs[i].bullet.MoveToAbs(-500,-500) end
		if (gbs[i].dead) then
			gbs[i].bullet.Remove()
			table.remove(gbs,i)
		end
	end

    onPlatform = onPlatform - 1
	hurt = 0
    if state == 0 then
	newpX = newpX
	newpY = newpY
	if Input.Right > 0 then
	    newpX = Player.x + 0.4
	end
	if Input.Left > 0 then
            newpX = Player.x - 0.4
	end
	if Input.Up > 0 then
	    newpY = Player.y + 0.4
	end
	if Input.Down > 0 then
            newpY = Player.y - 0.4
	end
	Player.MoveTo(newpX, newpY, false)
    end
    if state == 1 then -- Down
	newpX = newpX
	newpY = newpY
	if Input.Right > 0 then
	    newpX = Player.x + 0.5
	end
	if Input.Left > 0 then
            newpX = Player.x - 0.5
	end
	if onPlatform >= 1 then
	    newpX = newpX + platXV
	    newpY = newpY + platYV
	    if Input.Up > 0 then
	    	jump = maxjump
	    end
	end
	if newpY > topedge then
		if jump > 0 then
			jump = 0
		end
	end
	if Player.y < bottomedge + 2 then
	    if Input.Up > 0 then
	    	jump = maxjump
	    else
		newpY = bottomedge
		jump = 0
	    end
	elseif jump < 3 and jump > -3 then
	    jump = jump - 0.5
	elseif jump < -3 and jump > -10 then
	    jump = -10
	elseif jump < -3 then
	    jump = jump - 1.5
	else
	    jump = (jump/1.001) - 1
	end
	if Input.Up < 0 and jump > 3 then
	    jump = 2
	end
	newpY = newpY + (jump/10)
	Player.MoveTo(newpX, newpY, false)
    end
end


function OnHit(bullet)
	if bullet.getVar("canStand") == state then
		if jump < 0.1 and state == 1 then
			if Player.y >= bullet.y + 4 and Player.y <= bullet.y + 12 then -- You might want to adjust this if you have issues with custom platform sprites.
				if Input.Up > 0 then
	    				jump = maxjump
				else
					newpY = bullet.y + 8
		        		platXV = bullet.getVar("velx")
		        		platYV = bullet.getVar("vely")
		        		jump = 0
		        		onPlatform = 2
				end
			end
		end
	end
	if(bullet.GetVar('tile') ~= 1) then
		if (bullet.GetVar('color') == BLUE) then
			if (Player.isMoving) then
				Player.Hurt(4, 1/60)
				SetGlobal("hit1",true)
			end
		elseif (bullet.GetVar('color') == ORANGE) then
			if (not Player.isMoving) then
				Player.Hurt(4, 1/60)
				SetGlobal("hit1",true)
			end
		else
			Player.Hurt(4, 1/60)
			SetGlobal("hit1",true)
		end
	end
end